class PersoController < ApplicationController
  def perso
    # On récupère les possibilités en fonction de la classe, ainsi que la classe pour la base
    mes_jeux = Game.where(id: params[:jeu])
    if (mes_jeux.size != 1)
      @error = "Jeu non trouvé"
      return 1
    else
      mon_jeu = mes_jeux[0]
      @jeu_titre = mon_jeu.hack
    end

    mes_classes = Classe.where(id: params[:classe])
    if (mes_classes.size != 1)
      @error = "Classe non trouvée"
      return 1
    else
      ma_classe = mes_classes[0]
      @classe_titre = ma_classe.titre
      @base = ma_classe.base
    end
  
    equipements = Equipement.where(classe: ma_classe.id)
    if (equipements.size < 1)
      @error = "Liste d'équipements non trouvés"
      return 1
    end

    # tirage aléatoire FOR/DEX/VOL/PV en fonction des spécificité de la classe
    if (ma_classe.for == 3)
      @force = lance(3,6,0)
    elsif (ma_classe.for == 2)
      @force = lance(2,6,6)
    else
      @error = "Valeur de force non implémentée"
      return 1
    end

    if (ma_classe.dex == 3)
      @dexterite = lance(3,6,0)
    elsif (ma_classe.dex == 2)
      @dexterite = lance(2,6,6)
    else
      @error = "Valeur de dextérité non implémentée"
      return 1
    end

    if (ma_classe.vol == 3)
      @volonte = lance(3,6,0)
    elsif (ma_classe.vol == 2)
      @volonte = lance(2,6,6)
    else
      @error = "Valeur de volonté non implémentée"
      return 1
    end

    # pv avec type et pv_min
    pvmin = ma_classe.pv_min
    @pv = rand(ma_classe.pv).to_i + 1
    if (@pv < pvmin)
      @pv = pvmin
    end    
  
    # Equipement en fonction des tirages précédents
    max_car = [@force, @dexterite, @volonte].max
    liste_equip = equipements.select{ |item| item[:haute] == max_car && item[:pv] == @pv }
    # si trouvé, prendre aléatoire parmi ceux trouvés
    if (liste_equip.size > 0)
      @equip = liste_equip[rand(liste_equip.size).to_i][:liste]
    # sinon chercher avec valeur basse
    else
      seuil_min = equipements.min { |a, b| a[:haute] <=> b[:haute] }[:haute]
      liste_pv = equipements.select{ |item| item[:haute] == seuil_min && item[:pv] == @pv }
      liste_tot = equipements.select{ |item| item[:haute] == seuil_min }
      if (liste_pv.size > 0)
        @equip = liste_pv[rand(liste_pv.size).to_i][:liste]
    # sinon aléatoire dans toute la liste
      elsif (liste_tot.size > 0)
        @equip = liste_tot[rand(liste_tot.size).to_i][:liste]
      else
        @error = "Aucun equipement/capacité disponible"
        return 1
      end
    end
  end

  def lance(nb,type,bonus)
    v = 0
    nb.times do
      v += rand(type).to_i + 1 
    end
    v += bonus
    return v
  end
end
